import { ApiProperty } from "@nestjs/swagger";
import { Licitacion } from "src/licitaapp/application";

export class TenderTO {
    
    @ApiProperty({
        description: 'Tender total amount',
        example: 1545,
    })
    tenderId: number;
    
    @ApiProperty({
        description: 'new tenders amount',
        example: 16,
    })
    code: string;

    @ApiProperty({
        description: 'Tender description',
    })
    description: string;

    @ApiProperty({
        description: 'Tender details',
    })
    details: Licitacion;

    constructor(tenderId: number, code: string, details: Licitacion, description: string) {
        this.tenderId = tenderId;
        this.code = code;
        this.details = details;
        this.description = description;
    }
}